
![[Pasted image 20250322195148.png]]

**Default mode** for ASA is **Routed Mode**. 

Traffic that is initiated from a **higher security level** interface to a lower security level interface is **allowed** by **default**.

=====

### Firewall Modes

The Cisco Secure Firewall Adaptive Security Appliance (ASA) supports two primary firewall modes with unique operational characteristics:

#### Routed Mode

- **Default Mode**: ASA operates as a Layer 3 device (router).
- **Network Integration**: Requires IP readdressing for deployment.
- **Traffic Forwarding**: Based on destination IP addresses.
- **Routing Support**: Utilizes dynamic routing protocols like RIP (versions 1 and 2), OSPF, EIGRP, and BGP, or static routes.
- **Security Policies**: Supports NAT, access control lists, and security policy enforcement.

#### Transparent Mode

- **Operation**: Acts as a Layer 2 device, similar to a switch, in "bump in the wire" (BITW) fashion.
- **Network Integration**: Connects to the same IP subnet, avoiding readdressing.
- **Traffic Forwarding**: Based on destination MAC addresses.
- **Security Features**: Access lists, AAA, stateful packet inspection, AIC supported for unicast IPv4/IPv6 traffic.
- **Limitations**: Lacks support for dynamic routing protocols, DHCP Relay, multicast IP routing, VPN termination (except management connections), and other features.

### Routed Firewall Data Flow

- **Outbound Flow Steps**:
    1. Internal host requests a webpage from an internet server.
    2. ASA checks state table for active sessions and routing table for egress interface.
    3. NAT translation performed if configured, converting internal IP to a public IP.
    4. Packet forwarded through outside interface to destination.
    5. Server response allowed through ASA, utilizing existing session details.
    6. UN-NAT performed to convert public IP back to internal IP for host.

### Transparent Firewall Data Flow

- **Outbound Flow Steps**:
    1. Internal host requests a webpage from an internet server.
    2. ASA adds source MAC address to MAC address table if needed.
    3. Verifies packet against security policy (ACLs, filters, AAA).
    4. Performs stateful packet inspection and records session.
    5. ASA performs MAC address lookup for destination MAC.
    6. If MAC address is present, forwards packet out of the outside interface.
    7. If MAC address is absent, ASA uses ARP or ICMP to learn MAC address.
    8. Server response allowed back through ASA using established session details.

### Transparent Firewall Guidelines

- **Configuration Tasks**:
    - Change firewall mode from routed to transparent, clearing unsupported commands.
    - Set up bridge groups with BVIs; assign IP addresses for management and traffic.
    - Enable management interface for management traffic if supported.
- **Unsupported Features**:
    - DHCP Relay, DDNS, dynamic routing, multicast IP routing, QoS, VPN termination (except management), Cisco Unified Communications.

### Multiple-Context Mode Overview
![[Pasted image 20250322233928.png]]

- **Purpose**: Virtualization feature to implement distinct security policies for different customers or departments.
- **Modes**: Default single context mode or multiple-context mode.
- **Configuration**:
    - Convert ASA to multiple-context mode for virtual firewall implementation.
    - Each context operates independently with its own policy, interfaces, and admin.
- **Unsupported Features in Multiple Contexts**:
    - RIP, OSPFv3 dynamic routing, multicast routing, threat detection, QoS, Cisco Unified Communications.

### Packet Classification into Contexts

- **Classification Methods**:
    - Unique interfaces for contexts required in transparent mode.
    - Unique MAC addresses assigned per context on shared interfaces.
    - NAT configuration used for packet classification based on destination IP.

### Cisco Secure Firewall ASA Use Cases

- **Deployment Locations**:
    - **Internet Edge**: Control traffic at service provider edge, DMZ, VPN, and internet edge distribution.
    - **Data Center**: Implement virtualized firewall controls for server traffic isolation.
    - **Branch Offices**: Use ASA for IPsec VPN functionality and local traffic management.

### Important Notes

- **Security Context Limits**: Dependent on hardware model and optional licensing.
- **Context Configuration Files**:
    - **System Configuration**: Basic settings and list of contexts.
    - **Admin Context Configuration**: Initial context with administrative role.
    - **Individual Context Configurations**: Security policies and settings for each context.

This detailed summary outlines the operational modes, features, and configurations of the Cisco Secure Firewall ASA, providing a comprehensive understanding for deployment in various network environments.

